/* -*- Mode:C; Tab-width:4 -*- */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (b)(3)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 52.227-7013.           */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 2909                              */
/*                         AUSTIN, TEXAS 78769                           */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C) 1988, 1987, Texas Instruments Incorporated.            */
/*  All rights reserved.                                                 */
/*                                                                       */
/*------------------------------------------------------------------------------

	  Sample.r	-  Resources for the Sample Application

	  Copyright Apple Computer, Inc. 1985-1987
	  All rights reserved.

------------------------------------------------------------------------------*/

#include "Types.r"
#include "SysTypes.r"

/* These define's are used in the MENU resources to disable specific
   menu items. */
#define AllItems	0b1111111111111111111111111111111	/* 31 flags */
#define MenuItem1	0b00001
#define MenuItem2	0b00010
#define MenuItem3	0b00100
#define MenuItem4	0b01000
#define MenuItem5	0b10000

resource 'WIND' (128, "Sample Window") {
	{64, 60, 314, 460},
	documentProc, visible, noGoAway, 0x0, "Sample Window"
};


/*-------------------------------------SIZE---------------------------------------------*/
type 'SIZE' {
		boolean 				dontSaveScreen, 				/* Save screen			*/
								saveScreen;
		boolean 				ignoreSuspendResumeEvents,		/* suspend-resume		*/
								acceptSuspendResumeEvents;
		boolean					enableOptionSwitch,				/* option-key switching */
								disableOptionSwitch;
		boolean					cannotBackground,				/* accept Juggler bkgd */
								canBackground;
		boolean					notJugglerAware,
								JugglerAware;					/* follows Juggler's rules */
		boolean                 notBackgroundOnly,
		                        BackgroundOnly;
								
		unsigned bitstring[10] = 0; 							/* reserved 			*/
		unsigned longint;										/* size - 32k			*/
		unsigned longint;										/* min size - 32k		*/
};

resource 'SIZE' (-1) {
		dontSaveScreen, 				/* Save screen			*/
		acceptSuspendResumeEvents,		/* suspend-resume		*/
		enableOptionSwitch,				/* Options switch		*/
		canBackground,					/* accept Juggler background	*/
		JugglerAware,					/* Juggler aware		*/
		BackgroundOnly,
		210000,							/* size 				*/
		210000							/* min size - 32k		*/
};

resource 'DLOG' (128, "About LispM") {
	{66, 102, 224, 400},
	dBoxProc, visible, noGoAway, 0x0, 128, ""
};

resource 'DITL' (128) {
	 {
/* 1 */ {130, 205, 150, 284},
		button {
			enabled,
			"Continue"
		};
/* 2 */ {104, 144, 120, 293},				/*  Author Item */
		staticText {
			disabled,
			""
		};
/* 3 */ {88, 144, 105, 293},				/*  SourceLanguage Item */
		staticText {
			disabled,
			""
		};
/* 4 */ {8, 32, 26, 273},
		staticText {
			disabled,
			"LispMachine in the Macintosh II"
		};
/* 5 */ {32, 80, 50, 212},
		staticText {
			disabled,
			"------------------"
		};
/* 6 */ {56, 16, 74, 281},
		staticText {
			enabled, "Copyright  1987 Texas Instruments"
		};
/* 7 */ {88, 16, 104, 144},
		staticText {
			enabled, "Source Language:"
		};
/* 8 */ {104, 16, 120, 144},
		staticText {
			enabled, "Brought to you by:"
		}
	}
};

resource 'MENU' (128, "Apple", preload) {
	128, textMenuProc,
	AllItems & ~MenuItem2,	/* Disable item #2 */
	enabled, apple,
	{
		"About LispM",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain
	}
};

resource 'MENU' (129, "File", preload) {
	129, textMenuProc,
	allEnabled,
	enabled, "File",
	{
		"Quit",
			noicon, noKey, nomark, plain
	}
};

resource 'MENU' (130, "Edit", preload) {
	130, textMenuProc,
	AllItems & ~(MenuItem1 | MenuItem2),	/* Disable items #1 & #2 */
	enabled, "Edit",
	 {
		"Undo",
			noicon, "Z", nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Cut",
			noicon, "X", nomark, plain;
		"Copy",
			noicon, "C", nomark, plain;
		"Paste",
			noicon, "V", nomark, plain;
		"Clear",
			noicon, nokey, nomark, plain
	}
};

/* ab 11/8/88.  */
type 'TIMX' as 'STR ';

resource 'TIMX' (0) {
	"microExplorer NfsDaemon"
};

data 'ICN#' (128) { /* TI Bug ICON....Keith 1/27/88 */    /* ab 11/28/88 */
	$"0000 0000 007F 0000 007F 0000 007F 0000" 
	$"007F 0000 007F 0000 007F 0C00 007F 1E00" 
	$"007F CCF0 007F C1F8 007F DDF8 007F DDF8" 
	$"007E 1C38 7FFC 1C78 7FFC 187C 3FFF BBFE" 
	$"1FFF BBFE 0FFF BBFE 07FF 3BFE 03FF 33FE" 
	$"03E7 77FE 01C3 00FC 0003 01F0 0003 83C0" 
	$"0003 FF80 0001 FF00 0001 FE00 0000 FE00" 
	$"0000 7E00 0000 3F00 0000 0F00 0000 0000" 
	$"00FF 8000 00FF 8000 00FF 8000 00FF 8000" 
	$"00FF 8000 00FF 8C00 00FF 9E00 00FF FFF0" 
	$"00FF EFF8 00FF FFFC 00FF FFFC 00FF FFFC" 
	$"FFFF FFFC FFFE 1CFC FFFF FFFE 7FFF FFFF" 
	$"3FFF FFFF 1FFF FFFF 0FFF BFFF 07FF BFFF" 
	$"07FF FFFF 03E7 8FFE 01C7 83FC 0007 FFF0" 
	$"0007 FFC0 0003 FF80 0003 FF00 0001 FF00" 
	$"0000 FF00 0000 7F80 0000 3F80 0000 0F00" 
};


resource 'BNDL' (128) {
	'TIMX',					/* ab 11/8/88. */
	0,
	{
		'ICN#',
		{
			0, 128
		},
		'FREF',
		{
			0, 128
		}
	}
};


resource 'FREF' (128) {
	'APPL',
	0,
	""
};

resource 'ALRT' (128) {
	{28, 138, 228, 378},
	910,
	{	/* array: 4 elements */
		/* [1] */
		OK, visible, sound1;
		/* [2] */
		OK, visible, sound1;
		/* [3] */
		OK, visible, sound1;
		/* [4] */
		OK, visible, sound1
	}
};

resource 'DITL' (910) {
	{	/* array DITLarray: 3 elements */
		/* [1] */
		{126, 150, 146, 213},
		Button {
			enabled,
			"Continue"
		};
		/* [2] */
		{49, 11, 66, 207},
		StaticText {
			disabled,
			"^0"
		};
		/* [3] */
		{68, 52, 88, 130},
		StaticText {
			disabled,
			"^1"
		}
	}	
};


resource 'CURS' (22) {    /* Northwest arrow */
	$"0000 4000 6000 7000 7800 7C00 7E00 7F00"
	$"7800 6C00 4C00 0600 0600 0300 03",
	$"C000 E000 F000 F800 FC00 FE00 FF00 FF80"
	$"FFC0 FC00 FE00 CF00 8F00 0780 0780 0380",
	{1, 0}
};

resource 'CURS' (41) {	/*  Northeast arrow */
	$"0000 0010 0030 0070 00F0 01F0 03F0 07F0"
	$"00F0 01B0 0190 0300 0300 0600 06",
	$"0018 0038 0078 00F8 01F8 03F8 07F8 0FF8"
	$"0FF8 03F8 03F8 0798 0780 0F00 0F00 0E",
	{1, 10}
};

resource 'CURS' (36) {  /* Circle Plus */
	$"0000 0000 0780 1FE0 3B70 3330 6318 7FF8"
	$"7FF8 6318 3330 3B70 1FE0 0780",
	$"0000 0FC0 17A0 3FF0 7B78 F33C E31C FFFC"
	$"FFFC E31C F33C 7B78 3FF0 17A0 0FC0",
	{8, 7}
};

/*   Not used  
resource 'CURS' (100) {	 THin Circle Plus 
	$"0000 0000 07C0 0920 1110 2108 2108 3FF8"
	$"2108 2108 1110 0920 07C0",
	$"0000 07C0 0FE0 1930 3398 638C 6FEC 7FFC"
	$"6FEC 638C 3398 1930 0FE0 07C0",
	{7, 6}
};  not used  */

resource 'CURS' (33) {	/*  Upper left Corner  */
	$"0000 7FE0 7FE0 6000 6000 6000 6000 6000"
	$"6000 6000 60",
	$"FFF0 FFF0 FFF0 FFF0 F000 F000 F000 F000"
	$"F000 F000 F000 F0",
	{2, 1}
};

resource 'CURS' (34) {	/*  Lower Right Corner  */
	$"0000 0000 0030 0030 0030 0030 0030 0030"
	$"0030 0030 1FF0 1FF0",
	$"0000 0078 0078 0078 0078 0078 0078 0078"
	$"0078 3FF8 3FF8 3FF8 3FF8",
	{10, 9}
};

resource 'CURS' (112) {	/* Small Dot */
	$"0000 0000 0000 0000 0000 0300 03",
	$"0000 0000 0000 0000 0380 0780 0780 07",
	{5, 5}
};

resource 'CURS' (78) {	/* Thin hollow plus */
	$"0000 0100 0100 0100 0100 0100 3FF8 0100"
	$"0100 0100 0100 01",
	$"0000 0300 0300 0300 0300 0300 7FF8 7FF8"
	$"0300 0300 0300 0300 03",
	{6, 7}
};


resource 'CURS' (24) {  /* Thick Up Arrow */
	$"0000 0100 0380 07C0 0FE0 1FF0 07C0 07C0"
	$"07C0 07C0 07C0 07C0",
	$"0100 0380 07C0 0FE0 1FF0 3FF8 3FF8 0FE0"
	$"0FE0 0FE0 0FE0 0FE0 0FE0",
	{1, 7}
};

resource 'CURS' (26) {  /* Thick Down Arrow */
	$"0000 07C0 07C0 07C0 07C0 07C0 07C0 1FF0"
	$"0FE0 07C0 0380 01",
	$"0FE0 0FE0 0FE0 0FE0 0FE0 0FE0 3FF8 3FF8"
	$"1FF0 0FE0 07C0 0380 01",
	{11, 7}
};

resource 'CURS' (113) {  /* Thick Cross */
	$"0000 0000 3006 180C 0C18 0630 0360 01C0"
	$"01C0 0360 0630 0C18 180C 3006",
	$"0000 0000 700E 381C 1C38 0E70 07E0 03C0"
	$"03C0 07E0 0E70 1C38 381C 700E",
	{7, 8}
};

resource 'CURS' (28) {  /* Thick Up-Down Arrow */
	$"0000 0100 0380 07C0 0FE0 1FF0 07C0 07C0"
	$"07C0 07C0 1FF0 0FE0 07C0 0380 01",
	$"0100 0380 07C0 0FE0 1FF0 3FF8 3FF8 0FE0"
	$"0FE0 3FF8 3FF8 1FF0 0FE0 07C0 0380 01",
	{1, 7}
};

resource 'CURS' (40) {  /* Blank cursor */
	$"",
	$"",
	{2, 7}
};

resource 'FOND' (209, "Mouse") {
	0x0,
	209,
	0,
	0,
	0,
	0,
	0,
	0,
	0x0,
	0x0,
	0x0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	1,
	{	/* array FontEntries: 1 elements */
		/* [1] */
		16, 0, 26768
	},
	$""
};


resource 'FONT' (26768) {
	0xB001,
	0,
	217,
	16,
	0,
	-2,
	16,
	16,
	0x1F1,
	16,
	0,
	0,
	17,
	$"0000 0000 0000 800C 0000 0C1F FE00 1FFF"
	$"0000 2000 07C0 0F82 0008 0800 3801 C101"
	$"0010 0010 0800 0810 C01E 0000 1E1F FE00"
	$"1001 0000 6000 1FF0 3FE1 0010 0800 FE07"
	$"F181 8000 0018 1800 1818 E03F 0000 3F18"
	$"0000 1C07 0F00 E0E0 3838 7FF0 8020 0801"
	$"FF0E 39C1 C01C 001C 3800 381C F07F 8000"
	$"7F98 0000 0F1E 3FC1 E3F8 701C FFF8 4040"
	$"0803 FF98 0DE1 E0FF FFFE 7FFF 7FFE F8FF"
	$"C000 FFD8 0000 67BC 76E3 E71C 600C FFF8"
	$"2080 0803 FF98 8DF1 F1F1 FFFF FFFF FFFF"
	$"FDFF E3F1 FFF8 0000 63F8 6667 EC06 C007"
	$"FFFC 1100 0807 FFF0 87F9 F918 FFFE 7FFF"
	$"7FFE FE3F 03F0 3F18 0000 61F0 C63F ED16"
	$"C107 FDFC 0A00 080F FFF3 E7FD FC00 001C"
	$"3800 381C F03F 03F0 3F18 0000 60E0 FFF1"
	$"F8A3 C387 F8FC 0007 F7F7 FFF0 87E1 F1F0"
	$"0018 1800 1818 D83F 03F0 3F18 0000 61F0"
	$"FFF3 7843 C107 FDFC 0A00 0803 FF98 8DB1"
	$"B18A 0010 0800 0810 983F 03F0 3F18 0000"
	$"6358 C633 38A3 C007 FFFC 1100 0803 FF98"
	$"0D31 3000 0000 0000 0000 0C3F 1FFF FFF8"
	$"0000 664C 6666 0D16 600C FFF8 2080 0801"
	$"FF0E 3818 19FF 0000 0000 0000 0C00 0FFC"
	$"FFD8 0000 6CE6 76E6 0C06 701C FFF8 4040"
	$"0800 FE07 F018 1802 0000 0000 0000 0600"
	$"07F8 7F80 0000 79F3 3FCC 071C 3838 7FF0"
	$"8020 0800 3801 C00C 0C80 0000 0000 0000"
	$"0600 03F0 3F00 0000 73F9 0F0C 03F8 1FF0"
	$"3FE1 0010 0800 0000 000C 0C00 0000 0000"
	$"0000 0000 01E0 1E00 01FF FFFF 0000 00E0"
	$"07C0 0F82 0008 0800 0000 0006 0000 0000"
	$"0000 0000 0000 00C0 0C00 01FF E000 0000"
	$"0000 0000 0000 0000 0000 0000 0006 005B"
	$"0000 0000 0010 0010 0020 0020 0030 0037"
	$"0037 0043 0043 004F 004F 005B 005B 005B"
	$"005B 005B 0067 0073 0080 008C 008C 008C"
	$"008C 008C 0093 00A0 00A0 00A0 00A0 00A0"
	$"00A0 00A0 00A0 00A0 00A0 00AF 00BE 00BE"
	$"00BE 00BE 00BE 00BE 00BE 00BE 00BE 00BE"
	$"00BE 00BE 00BE 00BE 00BE 00BE 00BE 00BE"
	$"00BE 00BE 00BE 00BE 00BE 00CD 00CD 00DC"
	$"00DC 00DC 00DC 00DC 00DC 00DC 00DC 00DC"
	$"00DC 00DC 00DC 00DC 00DC 00DC 00DC 00DC"
	$"00DC 00DC 00DC 00DC 00DC 00DC 00DC 00DC"
	$"00DC 00DC 00DC 00DC 00DC 00DC 00DC 00DC"
	$"00DC 00DD 00DD 00DD 00EA 00EA 00EA 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00F7 00F7 00F7 00F7 00F7 00F7"
	$"00F7 00F7 00FF 0106 FFFF 0010 FFFF 0010"
	$"FFFF 0010 0010 FFFF 0010 0104 0010 FFFF"
	$"0010 0104 FFFF FFFF FFFF 0010 0410 0010"
	$"0010 FFFF FFFF FFFF FFFF 0910 0010 FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"0010 0010 FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"0010 FFFF 0010 FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF 0610 FFFF FFFF 0010"
	$"FFFF FFFF 0010 FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF FFFF FFFF FFFF FFFF 0010 0010 0000"
	$"0000 0109 0000 0109 0000 0109 000E 0000"
	$"000B 0000 050B 0000 0010 0000 0000 0000"
	$"0000 000C 040C 000F 020C 0000 0000 0000"
	$"0000 000E 020D 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 000F 000F 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 000F 0000 000F 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0601 0000 0000 000D 0000 0000 000D 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0000 0000 0000 0000 0000 0000 0000"
	$"0000 0010 000E C204"
};

